//
//  MCReportTable.h
//  Composer
//
//  Created by Alykhan Jetha on 23/07/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import "MCReportRegion.h"

@class MCReportTableAbstractRow;
@class MCReportTableSumRow;
@class MCReportTableSumTwoRow;
@class MCReportTableSumThreeRow;
@class MCReportTableDataRow;
@class MCReportTableHeaderRow;
@class MCReportTableConfigInfo;


@interface MCReportTable : MCReportRegion {
	BOOL automatedLayout;
	BOOL stretchLastRow;
	BOOL wantsAlternateRowColor;
	BOOL actAsLiveTable;
	NSColor *alternateRowColor;
	NSString *noDataText;
	MCReportTableConfigInfo *passiveConfigurationInfo;
	BOOL preventRowSplitting;  // in some cases people just don't want to split a row (invoice)

}

@property (nonatomic,assign) BOOL preventRowSplitting;

- (BOOL)automatedLayout;
- (void)setAutomatedLayout:(BOOL)flag;

- (BOOL)stretchLastRow;
- (void)setStretchLastRow:(BOOL)flag;

- (BOOL)actAsLiveTable;
- (void)setActAsLiveTable:(BOOL)flag;


- (BOOL)hasSummaryRows;

- (BOOL)canAddRemoveSummaryRow;
- (BOOL)hasSummaryRow;
- (void)setHasSummaryRow:(BOOL)hasRow;

- (BOOL)canAddRemoveSecondSummaryRow;
- (BOOL)hasSecondSummaryRow;
- (void)setHasSecondSummaryRow:(BOOL)hasRow;

- (BOOL)canAddRemoveThirdSummaryRow;
- (BOOL)hasThirdSummaryRow;
- (void)setHasThirdSummaryRow:(BOOL)hasRow;


- (BOOL)hasHeaderRow;
- (void)setHasHeaderRow:(BOOL)hasRow;

- (NSString *)noDataText;
- (void)setNoDataText:(NSString *)aNoDataText;

- (NSColor *)alternateRowColor;
- (void)setAlternateRowColor:(NSColor *)anAlternateRowColor;

- (BOOL)wantsAlternateRowColor;
- (void)setWantsAlternateRowColor:(BOOL)flag;

- (void)propagateDataInfo;

- (void)row:(MCReportTableAbstractRow *)aRow willAddCellAdjacentToCellAtIndex:(int)anIndex;
- (void)row:(MCReportTableAbstractRow *)aRow didAddCell:(MCReportElement *)element suggestedInsertionPoint:(NSPoint)insertPoint;
- (void)row:(MCReportTableAbstractRow *)aRow didDeleteCell:(MCReportElement *)element;
- (void)row:(MCReportTableAbstractRow *)aRow didResizeCell:(MCReportElement *)element;

- (MCReportTableHeaderRow *)getHeaderRow;
- (MCReportTableDataRow *)getDataRow;
- (MCReportTableSumRow *)getSumRow;
- (MCReportTableSumTwoRow *)getSecondSumRow;
- (MCReportTableSumThreeRow *)getThirdSumRow;

// only valuable during rendering
- (NSUInteger )numberOfDataRows;

- (BOOL)hasCells;
- (void)removeAllCells;

- (MCReportTableConfigInfo *)passiveConfigurationInfo;
- (void)setPassiveConfigurationInfo:(MCReportTableConfigInfo *)aPassiveConfigurationInfo;

- (void)configureColumnsUsingPassiveConfigurationInfo;

@end
